import jwt
from Crypto import Random
from Crypto.Cipher import AES
import base64
import json
from datetime import datetime
from hashlib import md5

BLOCK_SIZE = 16


def pad(data):
    length = BLOCK_SIZE - (len(data) % BLOCK_SIZE)
    return data + (chr(length) * length).encode()


def unpad(data):
    return data[: -(data[-1] if type(data[-1]) == int else ord(data[-1]))]


def bytes_to_key(data, salt, output=48):
    # extended from https://gist.github.com/gsakkis/4546068
    assert len(salt) == 8, len(salt)
    data += salt
    key = md5(data).digest()
    final_key = key
    while len(final_key) < output:
        key = md5(key + data).digest()
        final_key += key
    return final_key[:output]


def encrypt(message, passphrase):
    salt = Random.new().read(8)
    key_iv = bytes_to_key(passphrase, salt, 32 + 16)
    key = key_iv[:32]
    iv = key_iv[32:]
    aes = AES.new(key, AES.MODE_CBC, iv)
    return base64.b64encode(b"Salted__" + salt + aes.encrypt(pad(message)))


def decrypt(encrypted, passphrase):
    encrypted = base64.b64decode(encrypted)
    assert encrypted[0:8] == b"Salted__"
    salt = encrypted[8:16]
    key_iv = bytes_to_key(passphrase, salt, 32 + 16)
    key = key_iv[:32]
    iv = key_iv[32:]
    aes = AES.new(key, AES.MODE_CBC, iv)
    return unpad(aes.decrypt(encrypted[16:]))


def parse_jwt(authorization_header):
    if authorization_header.startswith("Bearer "):
        token = authorization_header[7:]
        try:
            decoded_token = jwt.decode(
                token, options={"verify_signature": False, "algorithms": ["HS256"]}
            )
            return decoded_token
        except jwt.ExpiredSignatureError:
            return {"error": "Token is expired"}
        except jwt.DecodeError:
            return {"error": "Token is not valid"}
    else:
        return {"error": "Invalid authorization format"}


request = {
    "body": {
        "data": "YOUR_ENCRYPTED_DATA",
    },
    "headers": {
        "authorization": "YOUR_JWT_TOKEN",
    },
}

request_data = request["body"]["data"]
request_authorization = request["headers"]["authorization"]
token_data = parse_jwt(request_authorization)

if "error" in token_data:
    print(json.dumps({"status": "ERROR", "message": token_data["error"]}))
else:
    wallet_id = token_data.get("id")
    salt = token_data.get("salt")
    exp = token_data.get("exp")

    if not wallet_id or not salt or not exp:
        print(json.dumps({"status": "ERROR", "message": "Token is not valid"}))
    # elif datetime.fromtimestamp(exp) < datetime.now():
    #     print(json.dumps({"status": "ERROR", "message": "Token is expired"}))
    else:
        final_salt = decrypt(salt, wallet_id.encode())
        decrypted_data = decrypt(request_data, final_salt)
        try:
            decrypted_data = json.loads(decrypted_data.decode("utf-8"))
            print(json.dumps(decrypted_data, indent=2))
        except json.JSONDecodeError:
            print(json.dumps({"status": "ERROR", "message": "Failed to decode data"}))
