const CryptoJS = require('crypto-js');
const jwt = require('jsonwebtoken');

// Function to decrypt a secret
const decrypt = (encryptedSecret, salt) => {
  const bytes = CryptoJS.AES.decrypt(encryptedSecret, salt);
  return bytes.toString(CryptoJS.enc.Utf8);
};

// Function to parse a JWT token
const parseJwt = (bearerToken) => {
  if (!bearerToken.startsWith('Bearer ')) {
    console.error('Invalid authorization format');
    return { error: 'Invalid authorization format' };
  }

  const token = bearerToken.slice(7);
  try {
    const decodedToken = jwt.decode(token);
    return decodedToken;
  } catch (error) {
    console.error('Error decoding the token:', error.message);
    return { error: 'Token is not valid' };
  }
};

const request = {
  body: {
    data: 'YOUR_ENCRYPTED_DATA',
  },
  headers: {
    authorization: 'YOUR_JWT_TOKEN',
  },
};

const { body, headers } = request;
if (headers && headers.authorization && body.data) {
  const decryptedJwtAuthorization = parseJwt(headers.authorization);
  const { id: walletId, salt, exp } = decryptedJwtAuthorization;

  if (!walletId || !salt || !exp) {
    console.error({ status: 'ERROR', message: 'Token is not valid' });
  } else {
    const finalSalt = decrypt(salt, walletId);
    const decryptedBody = JSON.parse(decrypt(body.data, finalSalt));
    console.log(decryptedBody);
  }
}
