<?php

namespace Cpay\Woocommerce;

final class PaymentStatus
{
    const PAYMENT_STATUS_PENDING = 'Pending';
    const PAYMENT_STATUS_ERROR = 'Error';
    const PAYMENT_STATUS_DONE = 'Done';
    const PAYMENT_STATUS_FAILED = 'Failed';

    const WC_STATUS_REFUNDED = 'refunded';
    const WC_STATUS_PENDING = 'pending';
    const WC_STATUS_PROCESSING = 'processing';
    const WC_STATUS_COMPLETED = 'completed';
    const WC_STATUS_FAIL = 'failed';
    const WC_STATUS_CANCELED = 'cancelled';
    const WC_STATUS_HOLD = 'on-hold';
    const WC_STATUS_WRONG_AMOUNT = 'wrong-amount';

    /**
     * @param $status
     * @return string
     */
    public static function convertToWoocommerceStatus(string $status, ?bool $all_downloadable_or_virtual = false): string
    {
        switch ($status) {
            case self::PAYMENT_STATUS_PENDING:
                $result = self::WC_STATUS_PENDING;
                break;

            case self::PAYMENT_STATUS_DONE:
                $result = self::WC_STATUS_COMPLETED;
                break;

            case self::PAYMENT_STATUS_FAILED:
            case self::PAYMENT_STATUS_ERROR:
                $result = self::WC_STATUS_FAIL;
                break;
        }
        if ($all_downloadable_or_virtual && $result === self::WC_STATUS_COMPLETED) {
            $result = self::WC_STATUS_COMPLETED;
        }

        return $result;
    }

    public static function isNeedReturnStocks($status)
    {
        $status = self::convertToWoocommerceStatus($status);

        if ($status === self::WC_STATUS_FAIL) {
            return true;
        }

        return false;
    }
}
