<?php

namespace Cpay\Woocommerce;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class BlockGateway extends AbstractPaymentMethodType
{
    protected $name = 'cpay';

    private $gateway;
    private $is_available;

    public function initialize()
    {
        // Initialize the payment method
        $this->gateway = new Gateway();
        $this->is_available = $this->gateway->is_available();
    }

    public function get_label()
    {
        return $this->gateway->title;
    }

    public function is_active()
    {
        return $this->is_available;
    }

    public function get_payment_method_script_handles()
    {
        $asset_path = __DIR__ . '/build/index.asset.php';
        $version = '1.0.0';
        $dependencies = [];

        if (file_exists($asset_path)) {
            $asset = require $asset_path;
            $version = $asset['version'];
            $dependencies = $asset['dependencies'];
        }

        wp_register_script(
            'cpay-blocks-integration',
            plugins_url('build/index.js', __FILE__),
            $dependencies,
            $version,
            true
        );

        return ['cpay-blocks-integration'];
    }

    public function get_payment_method_data()
    {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'supports' => $this->get_supported_features(),
            'icon' => $this->gateway->icon,
        ];
    }

    public function get_supported_features()
    {
        return [
            'products',
        ];
    }
}
